/*******************************************************************************
 *                                WINHEAD.TXT										
 *																					
 *                          $Date: 9/18/02 10:14a $									
 *																					
 *              Header Structure For WinView/WinSpec (WINX) Files					
 *																					
 * The current data file used for WINX files consists of a 4100 (1004 Hex)			
 * byte header followed by the data.												
 *																					
 * Beginning with Version 2.5, many more items were added to the header to				
 * make it a complete as possible record of the data collection.  This includes		
 * spectrograph and pulser information.  Much of these additions were accomplished	
 * by recycling old information which had not been used in many versions.			
 * All data files created under previous 2.x versions of WinView/WinSpec CAN		
 * still be read correctly.  HOWEVER, files created under the new versions			
 * (2.5 and higher) CANNOT be read by previous versions of WinView/WinSpec			
 * OR by the CSMA software package.													
 *
 *             ***************************************************
 *																					
 ******************************************************************************/

/*******************************************************************************
                                    Decimal Byte
                                       Offset
                                    -----------
  SHORT   ControllerVersion              0  Hardware Version
  SHORT   LogicOutput                    2  Definition of Output BNC
  WORD    AmpHiCapLowNoise               4  Amp Switching Mode
  WORD    xDimDet                        6  Detector x dimension of chip.
  SHORT   mode                           8  timing mode
  float   exp_sec                       10  alternitive exposure, in sec.
  SHORT   VChipXdim                     14  Virtual Chip X dim
  SHORT   VChipYdim                     16  Virtual Chip Y dim
  WORD    yDimDet                       18  y dimension of CCD or detector.
  char    date[DATEMAX]                 20  date
  SHORT   VirtualChipFlag               30  On/Off
  char    Spare_1[2]                    32
  SHORT   noscan                        34  Old number of scans - should always be -1
  float   DetTemperature                36  Detector Temperature Set
  SHORT   DetType                       40  CCD/DiodeArray type
  WORD    xdim                          42  actual # of pixels on x axis
  SHORT   stdiode                       44  trigger diode
  float   DelayTime                     46  Used with Async Mode
  WORD    ShutterControl                50  Normal, Disabled Open, Disabled Closed
  SHORT   AbsorbLive                    52  On/Off
  WORD    AbsorbMode                    54  Reference Strip or File
  SHORT   CanDoVirtualChipFlag          56  T/F Cont/Chip able to do Virtual Chip
  SHORT   ThresholdMinLive              58  On/Off
  float   ThresholdMinVal               60  Threshold Minimum Value
  SHORT   ThresholdMaxLive              64  On/Off
  float   ThresholdMaxVal               66  Threshold Maximum Value
  SHORT   SpecAutoSpectroMode           70  T/F Spectrograph Used
  float   SpecCenterWlNm                72  Center Wavelength in Nm
  SHORT   SpecGlueFlag                  76  T/F File is Glued
  float   SpecGlueStartWlNm             78  Starting Wavelength in Nm
  float   SpecGlueEndWlNm               82  Starting Wavelength in Nm
  float   SpecGlueMinOvrlpNm            86  Minimum Overlap in Nm
  float   SpecGlueFinalResNm            90  Final Resolution in Nm
  SHORT   PulserType                    94  0=None, PG200=1, PTG=2, DG535=3
  SHORT   CustomChipFlag                96  T/F Custom Chip Used
  SHORT   XPrePixels                    98  Pre Pixels in X direction
  SHORT   XPostPixels                  100  Post Pixels in X direction
  SHORT   YPrePixels                   102  Pre Pixels in Y direction 
  SHORT   YPostPixels                  104  Post Pixels in Y direction
  SHORT   asynen                       106  asynchron enable flag  0 = off
  SHORT   datatype                     108  experiment datatype
                                             0 =   FLOATING POINT
                                             1 =   LONG INTEGER
                                             2 =   INTEGER
                                             3 =   UNSIGNED INTEGER //---- SY 03-22-2004 ???? should be UINT16 or WORD or SHORT ????
  SHORT   PulserMode                   110  Repetitive/Sequential
  USHORT  PulserOnChipAccums           112  Num PTG On-Chip Accums
  DWORD   PulserRepeatExp              114  Num Exp Repeats (Pulser SW Accum)
  float   PulseRepWidth                118  Width Value for Repetitive pulse (usec)
  float   PulseRepDelay                122  Width Value for Repetitive pulse (usec)
  float   PulseSeqStartWidth           126  Start Width for Sequential pulse (usec)
  float   PulseSeqEndWidth             130  End Width for Sequential pulse (usec)
  float   PulseSeqStartDelay           134  Start Delay for Sequential pulse (usec)
  float   PulseSeqEndDelay             138  End Delay for Sequential pulse (usec)
  SHORT   PulseSeqIncMode              142  Increments: 1=Fixed, 2=Exponential
  SHORT   PImaxUsed                    144  PI-Max type controller flag
  SHORT   PImaxMode                    146  PI-Max mode
  SHORT   PImaxGain                    148  PI-Max Gain
  SHORT   BackGrndApplied              150  1 if background subtraction done
  SHORT   PImax2nsBrdUsed              152  T/F PI-Max 2ns Board Used
  WORD    minblk                       154  min. # of strips per skips
  WORD    numminblk                    156  # of min-blocks before geo skps
  SHORT   SpecMirrorLocation[2]        158  Spectro Mirror Location, 0=Not Present
  SHORT   SpecSlitLocation[4]          162  Spectro Slit Location, 0=Not Present
  SHORT   CustomTimingFlag             170  T/F Custom Timing Used
  char    ExperimentTimeLocal[TIMEMAX] 172  Experiment Local Time as hhmmss\0
  char    ExperimentTimeUTC[TIMEMAX]   179  Experiment UTC Time as hhmmss\0
  SHORT   ExposUnits                   186  User Units for Exposure
  WORD    ADCoffset                    188  ADC offset
  WORD    ADCrate                      190  ADC rate
  WORD    ADCtype                      192  ADC type
  WORD    ADCresolution                194  ADC resolution
  WORD    ADCbitAdjust                 196  ADC bit adjust
  WORD    gain                         198  gain
  char    Comments[5][COMMENTMAX]      200  File Comments
  WORD    geometric                    600  geometric ops: rotate 0x01,
                                             reverse 0x02, flip 0x04
  char    xlabel[LABELMAX]             602  intensity display string
  WORD    cleans                       618  cleans
  WORD    NumSkpPerCln                 620  number of skips per clean.
  SHORT   SpecMirrorPos[2]             622  Spectrograph Mirror Positions
  float   SpecSlitPos[4]               626  Spectrograph Slit Positions
  SHORT   AutoCleansActive             642  T/F
  SHORT   UseContCleansInst            644  T/F
  SHORT   AbsorbStripNum               646  Absorbance Strip Number
  SHORT   SpecSlitPosUnits             648  Spectrograph Slit Position Units
  float   SpecGrooves                  650  Spectrograph Grating Grooves
  SHORT   srccmp                       654  number of source comp. diodes
  WORD    ydim                         656  y dimension of raw data.
  SHORT   scramble                     658  0=scrambled,1=unscrambled
  SHORT   ContinuousCleansFlag         660  T/F Continuous Cleans Timing Option
  SHORT   ExternalTriggerFlag          662  T/F External Trigger Timing Option
  long    lnoscan                      664  Number of scans (Early WinX)
  long    lavgexp                      668  Number of Accumulations
  float   ReadoutTime                  672  Experiment readout time
  SHORT   TriggeredModeFlag            676  T/F Triggered Timing Option
  char    Spare_2[10]                  678  
  char    sw_version[FILEVERMAX]       688  Version of SW creating this file
  SHORT   type                         704   1 = new120 (Type II)             
                                             2 = old120 (Type I )           
                                             3 = ST130                      
                                             4 = ST121                      
                                             5 = ST138                      
                                             6 = DC131 (PentaMax)           
                                             7 = ST133 (MicroMax/SpectroMax)
                                             8 = ST135 (GPIB)               
                                             9 = VICCD                      
                                            10 = ST116 (GPIB)               
                                            11 = OMA3 (GPIB)                
                                            12 = OMA4                       
  SHORT   flatFieldApplied             706  1 if flat field was applied.
  char    Spare_3[16]                  708  
  SHORT   kin_trig_mode                724  Kinetics Trigger Mode
  char    dlabel[LABELMAX]             726  Data label.
  char    Spare_4[436]                 742
  char    PulseFileName[HDRNAMEMAX]   1178  Name of Pulser File with
                                             Pulse Widths/Delays (for Z-Slice)
  char    AbsorbFileName[HDRNAMEMAX]  1298 Name of Absorbance File (if File Mode)
  DWORD   NumExpRepeats               1418  Number of Times experiment repeated
  DWORD   NumExpAccums                1422  Number of Time experiment accumulated
  SHORT   YT_Flag                     1426  Set to 1 if this file contains YT data
  float   clkspd_us                   1428  Vert Clock Speed in micro-sec
  SHORT   HWaccumFlag                 1432  set to 1 if accum done by Hardware.
  SHORT   StoreSync                   1434  set to 1 if store sync used
  SHORT   BlemishApplied              1436  set to 1 if blemish removal applied
  SHORT   CosmicApplied               1438  set to 1 if cosmic ray removal applied
  SHORT   CosmicType                  1440  if cosmic ray applied, this is type
  float   CosmicThreshold             1442  Threshold of cosmic ray removal.  
  long    NumFrames                   1446  number of frames in file.         
  float   MaxIntensity                1450  max intensity of data (future)    
  float   MinIntensity                1454  min intensity of data (future)    
  char    ylabel[LABELMAX]            1458  y axis label.                     
  WORD    ShutterType                 1474  shutter type.                     
  float   shutterComp                 1476  shutter compensation time.        
  WORD    readoutMode                 1480  readout mode, full,kinetics, etc  
  WORD    WindowSize                  1482  window size for kinetics only.    
  WORD    clkspd                      1484  clock speed for kinetics & frame transfer
  WORD    interface_type              1486  computer interface                
                                             (isa-taxi, pci, eisa, etc.)             
  SHORT   NumROIsInExperiment         1488  May be more than the 10 allowed in
                                             this header (if 0, assume 1)            
  char    Spare_5[16]                 1490                                    
  WORD    controllerNum               1506  if multiple controller system will
                                             have controller number data came from.  
                                             this is a future item.                  
  WORD    SWmade                      1508  Which software package created this file 
  SHORT   NumROI                      1510  number of ROIs used. if 0 assume 1.      
                                      1512 - 1630  ROI information      
  struct ROIinfo { //---- SY 03-22-2004 ???? should be WORD or SHORT ????                                                   
   unsigned int startx                left x start value.               
   unsigned int endx                  right x value.                    
   unsigned int groupx                amount x is binned/grouped in hw. 
   unsigned int starty                top y start value.                
   unsigned int endy                  bottom y value.                   
   unsigned int groupy                amount y is binned/grouped in hw. 
  } ROIinfoblk[ROIMAX]                   ROI Starting Offsets:          
                                                  ROI  1 = 1512         
                                                  ROI  2 = 1524         
                                                  ROI  3 = 1536         
                                                  ROI  4 = 1548         
                                                  ROI  5 = 1560         
                                                  ROI  6 = 1572         
                                                  ROI  7 = 1584         
                                                  ROI  8 = 1596         
                                                  ROI  9 = 1608         
                                                  ROI 10 = 1620         
  char    FlatField[HDRNAMEMAX]       1632  Flat field file name.       
  char    background[HDRNAMEMAX]      1752  background sub. file name.  
  char    blemish[HDRNAMEMAX]         1872  blemish file name.          
  float   file_header_ver             1992  version of this file header 
  char    YT_Info[1000]               1996-2996  Reserved for YT information
  LONG    WinView_id                  2996  == 0x01234567L if file created by WinX

-------------------------------------------------------------------------------

                        START OF X CALIBRATION STRUCTURE

  double        offset                3000  offset for absolute data scaling
  double        factor                3008  factor for absolute data scaling
  char          current_unit          3016  selected scaling unit           
  char          reserved1             3017  reserved                        
  char          string[40]            3018  special string for scaling      
  char          reserved2[40]         3058  reserved                        
  char          calib_valid           3098  flag if calibration is valid    
  char          input_unit            3099  current input units for         
                                            "calib_value"                  
  char          polynom_unit          3100  linear UNIT and used            
                                            in the "polynom_coeff"         
  char          polynom_order         3101  ORDER of calibration POLYNOM    
  char          calib_count           3102  valid calibration data pairs    
  double        pixel_position[10]    3103  pixel pos. of calibration data  
  double        calib_value[10]       3183  calibration VALUE at above pos  
  double        polynom_coeff[6]      3263  polynom COEFFICIENTS            
  double        laser_position        3311  laser wavenumber for relativ WN 
  char          reserved3             3319  reserved                        
  unsigned char new_calib_flag        3320  If set to 200, valid label below
  char          calib_label[81]       3321  Calibration label (NULL term'd) 
  char          expansion[87]         3402  Calibration Expansion area      

-------------------------------------------------------------------------------

                        START OF Y CALIBRATION STRUCTURE

  double        offset                3489  offset for absolute data scaling
  double        factor                3497  factor for absolute data scaling
  char          current_unit          3505  selected scaling unit           
  char          reserved1             3506  reserved                        
  char          string[40]            3507  special string for scaling      
  char          reserved2[40]         3547  reserved                        
  char          calib_valid           3587  flag if calibration is valid    
  char          input_unit            3588  current input units for         
                                            "calib_value"                   
  char          polynom_unit          3589  linear UNIT and used            
                                            in the "polynom_coeff"          
  char          polynom_order         3590  ORDER of calibration POLYNOM    
  char          calib_count           3591  valid calibration data pairs    
  double        pixel_position[10]    3592  pixel pos. of calibration data  
  double        calib_value[10]       3672  calibration VALUE at above pos  
  double        polynom_coeff[6]      3752  polynom COEFFICIENTS            
  double        laser_position        3800  laser wavenumber for relativ WN 
  char          reserved3             3808  reserved                        
  unsigned char new_calib_flag        3809  If set to 200, valid label below
  char          calib_label[81]       3810  Calibration label (NULL term'd) 
  char          expansion[87]         3891  Calibration Expansion area      

                         END OF CALIBRATION STRUCTURES

    ---------------------------------------------------------------------

  char    Istring[40]                 3978  special intensity scaling string
  char    Spare_6[76]                 4018
  SHORT   AvGainUsed                  4094  avalanche gain was used
  SHORT   AvGain                      4096  avalanche gain value
  SHORT   lastvalue                   4098  Always the LAST value in the header
 ******************************************************************************/
                        /* 4100 Start of Data */
 
/******************************************************************************
 *	Definitions of array sizes:
 *	    HDRNAMEMAX  = 120     Max char str length for file name
 *	    USERINFOMAX = 1000    User information space
 *	    COMMENTMAX  = 80      User comment string max length (5 comments)
 *	    LABELMAX    = 16      Label string max length
 *	    FILEVERMAX  = 16      File version string max length
 *	    DATEMAX     = 10      String length of file creation date string as ddmmmyyyy\0
 *	    ROIMAX      = 10      Max size of roi array of structures
 *	    TIMEMAX     = 7       Max time store as hhmmss\0
 *	
 ******************************************************************************/
#define	HDRNAMEMAX	120		//Max char str length for file name
#define	USERINFOMAX	1000	//User information space
#define	COMMENTMAX	80		//User comment string max length (5 comments)
#define	LABELMAX	16		//Label string max length
#define	FILEVERMAX	16		//File version string max length
#define	DATEMAX		10		//String length of file creation date string as ddmmmyyyy\0
#define	ROIMAX		10		//Max size of roi array of structures
#define	TIMEMAX		7		//Max time store as hhmmss\0

// WinView/WinSpec(WINX) files experiment datatype
enum {
	SPE_DATATYPE_FLOAT,		//0 =   FLOATING POINT
	SPE_DATATYPE_LONG,		//1 =   LONG INTEGER
	SPE_DATATYPE_INT,		//2 =   INTEGER
	SPE_DATATYPE_UINT,		//3 =   UNSIGNED INTEGER (UINT16)
	/// Hong 09/28/08 QA80-12258 v8.0849 SPE_SUPPORT_MORE_DATE_TYPE
	// after Fisher's research, get more type info
	//0       ==>     3       ==>     FLOAT
	//1       ==>     2       ==>     LONG	
	//2       ==>     1       ==>     INT16	
	//3       ==>     6       ==>     UINT16	
	//4       ==>     0       ==>     invalid	
	//5       ==>     4       ==>     DOUBLE	
	//6       ==>     5       ==>     BYTE	
	//7       ==>     0       ==>     invalid	
	//8       ==>     7       ==>     ULONG	
	//>8     ==>     0        ==>    invalid
	SPE_DATATYPE_INVALID1,	//4 = invalid
	SPE_DATATYPE_DOUBLE,	//5
	SPE_DATATYPE_BYTE,		//6
	SPE_DATATYPE_INVALID2,	//7 = invalid
	SPE_DATATYPE_ULONG,	//8
	/// end SPE_SUPPORT_MORE_DATE_TYPE
};
/// Hong 09/28/08 QA80-12258 v8.0849 SPE_SUPPORT_MORE_DATE_TYPE
#define		IS_INVALID_SPE_DATATYPE(_ty)		( _ty < SPE_DATATYPE_FLOAT || _ty > SPE_DATATYPE_ULONG || SPE_DATATYPE_INVALID1 == _ty || SPE_DATATYPE_INVALID2 == _ty )
/// end SPE_SUPPORT_MORE_DATE_TYPE

#pragma pack(push,1)

// unsigned int is size 4, according byte offset in WINHEAD.txt, should change to WORD
typedef struct { //---- SY 03-22-2004 ???? should be WORD or SHORT ????                                                   
	WORD startx;//unsigned int startx;  //	left x start value.               
	WORD endx; 	//unsigned int endx;    //	right x value.                    
	WORD groupx;//unsigned int groupx;  //	amount x is binned/grouped in hw. 
	WORD starty;//unsigned int starty;  //	top y start value.                
	WORD endy;	//unsigned int endy;    //	bottom y value.                   
	WORD groupy;//unsigned int groupy;  //	amount y is binned/grouped in hw. 
} ROIinfo; 			                   	//	ROI Starting Offsets:          
                                        //	      ROI  1 = 1512         
                                        //	      ROI  2 = 1524         
                                        //	      ROI  3 = 1536         
                                        //	      ROI  4 = 1548         
                                        //	      ROI  5 = 1560         
                                        //	      ROI  6 = 1572         
                                        //	      ROI  7 = 1584         
                                        //	      ROI  8 = 1596         
                                        //	      ROI  9 = 1608         
                                        //	      ROI 10 = 1620         

                                        
typedef struct {
	double        offset;                	//	offset for absolute data scaling
	double        factor;                	//	factor for absolute data scaling
	char          current_unit;          	//	selected scaling unit           
	char          reserved1;             	//	reserved                        
	char          str[40];            		//	special string for scaling      
	char          reserved2[40];         	//	reserved                        
	char          calib_valid;           	//	flag if calibration is valid    
	char          input_unit;            	//	current input units for "calib_value"      
	char          polynom_unit;          	//	linear UNIT and used in the "polynom_coeff"           
	char          polynom_order;         	//	ORDER of calibration POLYNOM    
	char          calib_count;           	//	valid calibration data pairs
//#ifdef STRUCT2TREE
//	double        pixel_position[10];    	//	pixel pos. of calibration data  
//	double        calib_value[10];       	//	calibration VALUE at above pos  
//	double        polynom_coeff[6];      	//	polynom COEFFICIENTS            
//#else // !STRUCT2TREE
//	double        pixel_position[10];    	//	pixel pos. of calibration data
	double        pixel_position0;  
	double        pixel_position1;  
	double        pixel_position2;  
	double        pixel_position3;  
	double        pixel_position4;  
	double        pixel_position5;  
	double        pixel_position6;  
	double        pixel_position7;  
	double        pixel_position8;  
	double        pixel_position9;  
//	double        calib_value[10];       	//	calibration VALUE at above pos
	double        calib_value0;  
	double        calib_value1;  
	double        calib_value2;  
	double        calib_value3;  
	double        calib_value4;  
	double        calib_value5;  
	double        calib_value6;  
	double        calib_value7;  
	double        calib_value8;  
	double        calib_value9;  
//	double        polynom_coeff[6];      	//	polynom COEFFICIENTS
	double        polynom_coeff0;            
	double        polynom_coeff1;            
	double        polynom_coeff2;            
	double        polynom_coeff3;            
	double        polynom_coeff4;            
	double        polynom_coeff5;            
//#endif // STRUCT2TREE
	double        laser_position;        	//	laser wavenumber for relativ WN 
	char          reserved3;             	//	reserved                        
	unsigned char new_calib_flag;        	//	If set to 200, valid label below
	char          calib_label[81];       	//	Calibration label (NULL term'd) 
	char          expansion[87];         	//	Calibration Expansion area      
} SPECalib;

#ifndef SHORT
typedef short SHORT; /* signed           16 bit int */
#endif
	
typedef struct
	{ 
	SHORT   ControllerVersion;        		//    0  Hardware Version
	SHORT   LogicOutput;               		//    2  Definition of Output BNC
	WORD    AmpHiCapLowNoise;          		//    4  Amp Switching Mode
	WORD    xDimDet;                   		//    6  Detector x dimension of chip.
	SHORT   mode;                       	//    8  timing mode
	float   exp_sec;                    	//   10  alternitive exposure, in sec.
	SHORT   VChipXdim;                  	//   14  Virtual Chip X dim
	SHORT   VChipYdim;                  	//   16  Virtual Chip Y dim
	WORD    yDimDet;                    	//   18  y dimension of CCD or detector.
	char    date[DATEMAX];              	//   20  date
	SHORT   VirtualChipFlag;            	//   30  On/Off
	char    Spare_1[2];                 	//   32
	SHORT   noscan;                     	//   34  Old number of scans - should always be -1
	float   DetTemperature;             	//   36  Detector Temperature Set
	SHORT   DetType;                    	//   40  CCD/DiodeArray type
	WORD    xdim;                       	//   42  actual # of pixels on x axis
	SHORT   stdiode;                    	//   44  trigger diode
	float   DelayTime;                  	//   46  Used with Async Mode
	WORD    ShutterControl;             	//   50  Normal, Disabled Open, Disabled Closed
	SHORT   AbsorbLive;                 	//   52  On/Off
	WORD    AbsorbMode;                 	//   54  Reference Strip or File
	SHORT   CanDoVirtualChipFlag;       	//   56  T/F Cont/Chip able to do Virtual Chip
	SHORT   ThresholdMinLive;           	//   58  On/Off
	float   ThresholdMinVal;            	//   60  Threshold Minimum Value
	SHORT   ThresholdMaxLive;           	//   64  On/Off
	float   ThresholdMaxVal;            	//   66  Threshold Maximum Value
	SHORT   SpecAutoSpectroMode;        	//   70  T/F Spectrograph Used
	float   SpecCenterWlNm;             	//   72  Center Wavelength in Nm
	SHORT   SpecGlueFlag;               	//   76  T/F File is Glued
	float   SpecGlueStartWlNm;          	//   78  Starting Wavelength in Nm
	float   SpecGlueEndWlNm;            	//   82  Starting Wavelength in Nm
	float   SpecGlueMinOvrlpNm;         	//   86  Minimum Overlap in Nm
	float   SpecGlueFinalResNm;         	//   90  Final Resolution in Nm
	SHORT   PulserType;                 	//   94  0=None, PG200=1, PTG=2, DG535=3
	SHORT   CustomChipFlag;             	//   96  T/F Custom Chip Used
	SHORT   XPrePixels;                 	//   98  Pre Pixels in X direction
	SHORT   XPostPixels;                	//  100  Post Pixels in X direction
	SHORT   YPrePixels;                 	//  102  Pre Pixels in Y direction 
	SHORT   YPostPixels;                	//  104  Post Pixels in Y direction
	SHORT   asynen;                     	//  106  asynchron enable flag  0 = off
	SHORT   datatype;                   	//  108  experiment datatype
	                                    	//     0 =   FLOATING POINT
	                                    	//     1 =   LONG INTEGER
	                                    	//     2 =   INTEGER
	                                    	//     3 =   UNSIGNED INTEGER
	SHORT   PulserMode;                 	//  110  Repetitive/Sequential
	USHORT  PulserOnChipAccums;         	//  112  Num PTG On-Chip Accums
	DWORD   PulserRepeatExp;            	//  114  Num Exp Repeats (Pulser SW Accum)
	float   PulseRepWidth;              	//  118  Width Value for Repetitive pulse (usec)
	float   PulseRepDelay;              	//  122  Width Value for Repetitive pulse (usec)
	float   PulseSeqStartWidth;         	//  126  Start Width for Sequential pulse (usec)
	float   PulseSeqEndWidth;           	//  130  End Width for Sequential pulse (usec)
	float   PulseSeqStartDelay;         	//  134  Start Delay for Sequential pulse (usec)
	float   PulseSeqEndDelay;           	//  138  End Delay for Sequential pulse (usec)
	SHORT   PulseSeqIncMode;            	//  142  Increments: 1=Fixed, 2=Exponential
	SHORT   PImaxUsed;                  	//  144  PI-Max type controller flag
	SHORT   PImaxMode;                  	//  146  PI-Max mode
	SHORT   PImaxGain;                  	//  148  PI-Max Gain
	SHORT   BackGrndApplied;           	 	//  150  1 if background subtraction done
	SHORT   PImax2nsBrdUsed;            	//  152  T/F PI-Max 2ns Board Used
	WORD    minblk;                     	//  154  min. # of strips per skips
	WORD    numminblk;                  	//  156  # of min-blocks before geo skps
//#ifdef STRUCT2TREE
//	SHORT   SpecMirrorLocation[2];			//  158  Spectro Mirror Location, 0=Not Present
//	SHORT   SpecSlitLocation[4];			//  162  Spectro Slit Location, 0=Not Present
//#else // !STRUCT2TREE	
//	SHORT   SpecMirrorLocation[2];      	//  158  Spectro Mirror Location, 0=Not Present
	SHORT	SpecMirrorLocation0;
	SHORT	SpecMirrorLocation1;
//	SHORT   SpecSlitLocation[4];        	//  162  Spectro Slit Location, 0=Not Present
	SHORT   SpecSlitLocation0;
	SHORT   SpecSlitLocation1;
	SHORT   SpecSlitLocation2;
	SHORT   SpecSlitLocation3;
//#endif // STRUCT2TREE
	SHORT   CustomTimingFlag;           	//  170  T/F Custom Timing Used
	char    ExperimentTimeLocal[TIMEMAX]; 	//	172  Experiment Local Time as hhmmss\0
	char    ExperimentTimeUTC[TIMEMAX];   	//	179  Experiment UTC Time as hhmmss\0
	SHORT   ExposUnits;                   	//	186  User Units for Exposure
	WORD    ADCoffset;                    	//	188  ADC offset
	WORD    ADCrate;                      	//	190  ADC rate
	WORD    ADCtype;                      	//	192  ADC type
	WORD    ADCresolution;                	//	194  ADC resolution
	WORD    ADCbitAdjust;                 	//	196  ADC bit adjust
	WORD    gain;                         	//	198  gain
//	char    Comments[5][COMMENTMAX];      	//	200  File Comments
	char    Comments0[COMMENTMAX];      	//	200  File Comments
	char    Comments1[COMMENTMAX];      	//	200  File Comments
	char    Comments2[COMMENTMAX];      	//	200  File Comments
	char    Comments3[COMMENTMAX];      	//	200  File Comments
	char    Comments4[COMMENTMAX];      	//	200  File Comments
	
	WORD    geometric;                    	//	600  geometric ops: rotate 0x01,
	                                        //	 	reverse 0x02, flip 0x04
	char    xlabel[LABELMAX];             	//	602  intensity display string
	WORD    cleans;                       	//	618  cleans
	WORD    NumSkpPerCln;                 	//	620  number of skips per clean.
//#ifdef STRUCT2TREE
//	SHORT   SpecMirrorPos[2];             	//	622  Spectrograph Mirror Positions
//	float   SpecSlitPos[4];               	//	626  Spectrograph Slit Positions
//#else // !STRUCT2TREE	
//	SHORT   SpecMirrorPos[2];             	//	622  Spectrograph Mirror Positions
	SHORT 	SpecMirrorPos0;
	SHORT 	SpecMirrorPos1;
//	float   SpecSlitPos[4];               	//	626  Spectrograph Slit Positions
	float   SpecSlitPos0;
	float   SpecSlitPos1;
	float   SpecSlitPos2;
	float   SpecSlitPos3;
//#endif // STRUCT2TREE
	SHORT   AutoCleansActive;             	//	642  T/F
	SHORT   UseContCleansInst;            	//	644  T/F
	SHORT   AbsorbStripNum;               	//	646  Absorbance Strip Number
	SHORT   SpecSlitPosUnits;             	//	648  Spectrograph Slit Position Units
	float   SpecGrooves;                  	//	650  Spectrograph Grating Grooves
	SHORT   srccmp;                       	//	654  number of source comp. diodes
	WORD    ydim;                         	//	656  y dimension of raw data.
	SHORT   scramble;                     	//	658  0=scrambled,1=unscrambled
	SHORT   ContinuousCleansFlag;         	//	660  T/F Continuous Cleans Timing Option
	SHORT   ExternalTriggerFlag;          	//	662  T/F External Trigger Timing Option
	long    lnoscan;                      	//	664  Number of scans (Early WinX)
	long    lavgexp;                      	//	668  Number of Accumulations
	float   ReadoutTime;                  	//	672  Experiment readout time
	SHORT   TriggeredModeFlag;            	//	676  T/F Triggered Timing Option
	char    Spare_2[10];                  	//	678  
	char    sw_version[FILEVERMAX];       	//	688  Version of SW creating this file
	SHORT   type;                         	//	704   	1 = new120 (Type II)             
	                                        //	 		2 = old120 (Type I )           
	                                        //	 		3 = ST130                      
	                                        //	 		4 = ST121                      
	                                        //	 		5 = ST138                      
	                                        //	 		6 = DC131 (PentaMax)           
	                                        //	 		7 = ST133 (MicroMax/SpectroMax)
	                                        //	 		8 = ST135 (GPIB)               
	                                        //	 		9 = VICCD                      
	                                        //			10 = ST116 (GPIB)               
	                                        //			11 = OMA3 (GPIB)                
	                                        //			12 = OMA4                       
	SHORT   flatFieldApplied;            	//	706  1 if flat field was applied.
	char    Spare_3[16];                  	//	708  
	SHORT   kin_trig_mode;                	//	724  Kinetics Trigger Mode
	char    dlabel[LABELMAX];             	//	726  Data label.
	char    Spare_4[436];                 	//	742
	char    PulseFileName[HDRNAMEMAX];   	//	1178  Name of Pulser File with
	                                        //	 	  Pulse Widths/Delays (for Z-Slice)
	char    AbsorbFileName[HDRNAMEMAX];  	//	1298 Name of Absorbance File (if File Mode)

	DWORD   NumExpRepeats;               	//	1418  Number of Times experiment repeated
	DWORD   NumExpAccums;                	//	1422  Number of Time experiment accumulated
	SHORT   YT_Flag;                     	//	1426  Set to 1 if this file contains YT data
	float   clkspd_us;                   	//	1428  Vert Clock Speed in micro-sec
	SHORT   HWaccumFlag;                 	//	1432  set to 1 if accum done by Hardware.
	SHORT   StoreSync;                   	//	1434  set to 1 if store sync used
	SHORT   BlemishApplied;              	//	1436  set to 1 if blemish removal applied
	SHORT   CosmicApplied;               	//	1438  set to 1 if cosmic ray removal applied
	SHORT   CosmicType;                  	//	1440  if cosmic ray applied, this is type
	float   CosmicThreshold;             	//	1442  Threshold of cosmic ray removal.  
	long    NumFrames;                   	//	1446  number of frames in file.         
	float   MaxIntensity;               	//	1450  max intensity of data (future)    
	float   MinIntensity;               	//	1454  min intensity of data (future)    
	char    ylabel[LABELMAX];           	//	1458  y axis label.                     
	WORD    ShutterType;                 	//	1474  shutter type.                     
	float   shutterComp;                 	//	1476  shutter compensation time.        
	WORD    readoutMode;                 	//	1480  readout mode, full,kinetics, etc  
	WORD    WindowSize;                  	//	1482  window size for kinetics only.    
	WORD    clkspd;                      	//	1484  clock speed for kinetics & frame transfer
	WORD    interface_type;              	//	1486  computer interface                
	                                        //	 	  (isa-taxi, pci, eisa, etc.)             
	SHORT   NumROIsInExperiment;         	//	1488  May be more than the 10 allowed in
	                                        //	      this header (if 0, assume 1)            
	char    Spare_5[16];                 	//	1490                                    
	WORD    controllerNum;               	//	1506  if multiple controller system will
	                                        //	      have controller number data came from.  
	                                        //	      this is a future item.                  
	WORD    SWmade;                      	//	1508  Which software package created this file 
	SHORT   NumROI;                      	//	1510  number of ROIs used. if 0 assume 1.      
	                                  		//	1512 - 1630  ROI information      
//#ifdef STRUCT2TREE
//	ROIinfo ROIinfoblk[ROIMAX];
//#else // !STRUCT2TREE
	WORD	ROIinfoblk0startx;
	WORD	ROIinfoblk0endx;
	WORD	ROIinfoblk0groupx;
	WORD	ROIinfoblk0starty;
	WORD	ROIinfoblk0endy;
	WORD	ROIinfoblk0groupy;
	
	WORD	ROIinfoblk1startx;
	WORD	ROIinfoblk1endx;
	WORD	ROIinfoblk1groupx;
	WORD	ROIinfoblk1starty;
	WORD	ROIinfoblk1endy;
	WORD	ROIinfoblk1groupy;
	
	WORD	ROIinfoblk2startx;
	WORD	ROIinfoblk2endx;
	WORD	ROIinfoblk2groupx;
	WORD	ROIinfoblk2starty;
	WORD	ROIinfoblk2endy;
	WORD	ROIinfoblk2groupy;
	
	WORD	ROIinfoblk3startx;
	WORD	ROIinfoblk3endx;
	WORD	ROIinfoblk3groupx;
	WORD	ROIinfoblk3starty;
	WORD	ROIinfoblk3endy;
	WORD	ROIinfoblk3groupy;
	
	WORD	ROIinfoblk4startx;
	WORD	ROIinfoblk4endx;
	WORD	ROIinfoblk4groupx;
	WORD	ROIinfoblk4starty;
	WORD	ROIinfoblk4endy;
	WORD	ROIinfoblk4groupy;
	
	WORD	ROIinfoblk5startx;
	WORD	ROIinfoblk5endx;
	WORD	ROIinfoblk5groupx;
	WORD	ROIinfoblk5starty;
	WORD	ROIinfoblk5endy;
	WORD	ROIinfoblk5groupy;
	
	WORD	ROIinfoblk6startx;
	WORD	ROIinfoblk6endx;
	WORD	ROIinfoblk6groupx;
	WORD	ROIinfoblk6starty;
	WORD	ROIinfoblk6endy;
	WORD	ROIinfoblk6groupy;
	
	WORD	ROIinfoblk7startx;
	WORD	ROIinfoblk7endx;
	WORD	ROIinfoblk7groupx;
	WORD	ROIinfoblk7starty;
	WORD	ROIinfoblk7endy;
	WORD	ROIinfoblk7groupy;
	
	WORD	ROIinfoblk8startx;
	WORD	ROIinfoblk8endx;
	WORD	ROIinfoblk8groupx;
	WORD	ROIinfoblk8starty;
	WORD	ROIinfoblk8endy;
	WORD	ROIinfoblk8groupy;
	
	WORD	ROIinfoblk9startx;
	WORD	ROIinfoblk9endx;
	WORD	ROIinfoblk9groupx;
	WORD	ROIinfoblk9starty;
	WORD	ROIinfoblk9endy;
	WORD	ROIinfoblk9groupy;
//#endif // STRUCT2TREE
	char    FlatField[HDRNAMEMAX];       	//	1632  Flat field file name.       
	char    background[HDRNAMEMAX];      	//	1752  background sub. file name.  
	char    blemish[HDRNAMEMAX];         	//	1872  blemish file name.          
	float   file_header_ver;             	//	1992  version of this file header 
	char    YT_Info[1000];               	//	1996-2996  Reserved for YT information
	LONG    WinView_id;                  	//	2996  == 0x01234567L if file created by WinX
	//-------------------------------------------------------------------------------
	
	//                    START OF X CALIBRATION STRUCTURE
//#ifdef STRUCT2TREE
//	SPECalib calib_x;
		
	//                    START OF Y CALIBRATION STRUCTURE
//	SPECalib calib_y;
//#else // !STRUCT2TREE
	//                    START OF X CALIBRATION STRUCTURE
	double        calib_xoffset;                	//	offset for absolute data scaling
	double        calib_xfactor;                	//	factor for absolute data scaling
	char          calib_xcurrent_unit;          	//	selected scaling unit           
	char          calib_xreserved1;             	//	reserved                        
	char          calib_xstr[40];            		//	special string for scaling      
	char          calib_xreserved2[40];         	//	reserved                        
	char          calib_xcalib_valid;           	//	flag if calibration is valid    
	char          calib_xinput_unit;            	//	current input units for "calib_value"      
	char          calib_xpolynom_unit;          	//	linear UNIT and used in the "polynom_coeff"           
	char          calib_xpolynom_order;         	//	ORDER of calibration POLYNOM    
	char          calib_xcalib_count;           	//	valid calibration data pairs
	double        calib_xpixel_position0;  
	double        calib_xpixel_position1;  
	double        calib_xpixel_position2;  
	double        calib_xpixel_position3;  
	double        calib_xpixel_position4;  
	double        calib_xpixel_position5;  
	double        calib_xpixel_position6;  
	double        calib_xpixel_position7;  
	double        calib_xpixel_position8;  
	double        calib_xpixel_position9;  
	double        calib_xcalib_value0;  
	double        calib_xcalib_value1;  
	double        calib_xcalib_value2;  
	double        calib_xcalib_value3;  
	double        calib_xcalib_value4;  
	double        calib_xcalib_value5;  
	double        calib_xcalib_value6;  
	double        calib_xcalib_value7;  
	double        calib_xcalib_value8;  
	double        calib_xcalib_value9;  
	double        calib_xpolynom_coeff0;            
	double        calib_xpolynom_coeff1;            
	double        calib_xpolynom_coeff2;            
	double        calib_xpolynom_coeff3;            
	double        calib_xpolynom_coeff4;            
	double        calib_xpolynom_coeff5;            
	double        calib_xlaser_position;        	//	laser wavenumber for relativ WN 
	char          calib_xreserved3;             	//	reserved                        
	unsigned char calib_xnew_calib_flag;        	//	If set to 200, valid label below
	char          calib_xcalib_label[81];       	//	Calibration label (NULL term'd) 
	char          calib_xexpansion[87];         	//	Calibration Expansion area      
	
	/////////////////////////////////////////////////////////////////////////
	//                    START OF Y CALIBRATION STRUCTURE
	double        calib_yoffset;                	//	offset for absolute data scaling
	double        calib_yfactor;                	//	factor for absolute data scaling
	char          calib_ycurrent_unit;          	//	selected scaling unit           
	char          calib_yreserved1;             	//	reserved                        
	char          calib_ystr[40];            		//	special string for scaling      
	char          calib_yreserved2[40];         	//	reserved                        
	char          calib_ycalib_valid;           	//	flag if calibration is valid    
	char          calib_yinput_unit;            	//	current input units for "calib_value"      
	char          calib_ypolynom_unit;          	//	linear UNIT and used in the "polynom_coeff"           
	char          calib_ypolynom_order;         	//	ORDER of calibration POLYNOM    
	char          calib_ycalib_count;           	//	valid calibration data pairs
	double        calib_ypixel_position0;  
	double        calib_ypixel_position1;  
	double        calib_ypixel_position2;  
	double        calib_ypixel_position3;  
	double        calib_ypixel_position4;  
	double        calib_ypixel_position5;  
	double        calib_ypixel_position6;  
	double        calib_ypixel_position7;  
	double        calib_ypixel_position8;  
	double        calib_ypixel_position9;  
	double        calib_ycalib_value0;  
	double        calib_ycalib_value1;  
	double        calib_ycalib_value2;  
	double        calib_ycalib_value3;  
	double        calib_ycalib_value4;  
	double        calib_ycalib_value5;  
	double        calib_ycalib_value6;  
	double        calib_ycalib_value7;  
	double        calib_ycalib_value8;  
	double        calib_ycalib_value9;  
	double        calib_ypolynom_coeff0;            
	double        calib_ypolynom_coeff1;            
	double        calib_ypolynom_coeff2;            
	double        calib_ypolynom_coeff3;            
	double        calib_ypolynom_coeff4;            
	double        calib_ypolynom_coeff5;            
	double        calib_ylaser_position;        	//	laser wavenumber for relativ WN 
	char          calib_yreserved3;             	//	reserved                        
	unsigned char calib_ynew_calib_flag;        	//	If set to 200, valid label below
	char          calib_ycalib_label[81];       	//	Calibration label (NULL term'd) 
	char          calib_yexpansion[87];         	//	Calibration Expansion area      
//#endif // STRUCT2TREE
	//                     END OF CALIBRATION STRUCTURES
	
	//---------------------------------------------------------------------
	
	char    Istring[40];                 	//	3978  special intensity scaling string
	char    Spare_6[76];                 	//	4018
	SHORT   AvGainUsed;                  	//	4094  avalanche gain was used
	SHORT   AvGain;                      	//	4096  avalanche gain value
	SHORT   lastvalue;                   	//	4098  Always the LAST value in the header
	                    /* 4100 Start of Data */
	} SPEHEADER; 	

#pragma pack(pop)

/******************************************************************************
 *	
 *	                      READING STRIPS AND FRAMES OF DATA
 *	                     -----------------------------------
 *	
 *	    The data follows the header beginning at offset 4100.
 *	
 *	    Data is still stored as sequential points.  The X, Y and Frame dimensions
 *	    are determined by the header.
 *	    The X dimension of the stored data is in "xdim" ( Offset 42  ).
 *	    The Y dimension of the stored data is in "ydim" ( Offset 656 ).
 *	    The number of frames of data stored is in "NumFrames" ( Offset 1446 ).
 *	
 *	    Thus (modifying the example above):
 *	
 *	        char header[4100];
 *	        unsigned int X_dimension;
 *	        unsigned int Y_dimension;
 * 	        long         Num_frames;
 *	
 *	    Now there is Direct Access of data dimensions
 *
 *	        X_dimension = (unsigned int)header[42];
 *	        Y_dimension = (unsigned int)header[664];
 *	        Num_frames  = (long)header[1446];
 *
 ******************************************************************************/
 
///Sophy 10/20/2009 QA80-12258-P3 IMPROVE_FILE_INFORMATION_WITH_MEANINGFUL_VALS
/*********  ADD NEW DETECTORS TO END OF LIST!!  *********/
/*                                                      */
/******  Also add detector to 'ccd_resource_xref'  ******/
/* #### used by PICM_CREATECONTROLLER param 2 (if ccd) #### */
enum ctrl_CCD_sensor
{
                               /*             DLL/WinView        Y     X          */
    CUSTOM_CCD = -1,           /*  Custom User defined CCD chip                   */
/*** CUSTOM_CCD AS A CHIP TYPE IS NO LONGER USED !!!! ***/

                               /* CCD	                                            */
    NO_CCD_SENSOR,             /* Enum       PN#  CCD                X     Y      */
    EEV_256x1024_3ph,          /*     EEV 256x1024 3-phase           256  1024    */
    EEV_576x384_3ph,           /*     EEV 576x384 3-phase            576   384    */
    EEV_1152x298_3ph,          /*     EEV 1152x298 3-phase          1152   298    */
    EEV_1152x1242_3ph,         /*     EEV 1152x1242                 1152  1242    */
    KDK_512x768,               /*   5 KODAK 512x768                  512   768    */
    KDK_1035x1317,             /*     KODAK 1035x1317               1035  1317    */
    KDK_1024x1280,             /*     KODAK 1024x1280               1024  1280    */
    KDK_2044x2033,             /*     KODAK 2044x2033               2044  2033    */
    KDK_2048x3072,             /*     KODAK 2048x3072               2048  3072    */
                               /*     Fast kodak special, will be removed in future */
    KODAKFAST1400,             /*  10 Use custom chip               1035  1317    */
                               /*     Overscan special, will be removed in future */
    OSTK1024B,                 /*     Use custom chip               1050  1050    */
    PID_330x1100_8phH,         /*     PI 330x1100 8 phase (horz)     330  1100    */
    PID_532x1752,              /*     PI 532x1752                    532  1752    */
    RET_400x1200,              /*     RET 400x1200                   400  1200    */
    RET_512x512,               /*  15 RET 512x512                    512   512    */
    FCD_4096x4096F_MT,         /*     Fairchild 4K x 4K MultiTap   2048x2 2048x2  */
    RET_1024x1024,             /*     RET 1K x 1K                   1024  1024    */
    RET_2048x2048,             /*     RET 2K x 2K                   2048  2048    */
    TEK_512x512_B_100ns,       /*     TEK512x512B Back  [100ns]      512   512    */
    TEK_512x512_F_100ns,       /*  20 TEK512x512F Front [100ns]      512   512    */
    TEK_1024x1024_B_100ns,     /*     TEK1024x1024B Back [100ns]    1024  1024    */
    TEK_1024x1024_F_100ns,     /*     TEK1024x1024F Front[100ns]    1024  1024    */
    TEK_2048x2048,             /*     TEK 2K x 2K                   2048  2048    */
    THM_576x384,               /*     TH576x384                      576   384    */
    EEV_256x1024_6ph,          /*  25 EEV 256x1024  6 PHASE          256  1024    */
    EEV_1024x512_FT,           /*     EEV frame transfer            1024   512    */
    EEV_1024x512_FT_CCD57_FI,  /*     EEV FT CCD 57 Front Illum.    1024   512    */
    SUI_256x320,               /*     Sensor Unlimited, Inc, SU320AS 320   256    */
    EEV_576x384_6ph,           /*     EEV576x384   6 PHASE           576   384    */
    EEV_1152x298_6ph,          /*  30 EEV1152x298  6 PHASE          1152   298    */
    EEV_1152x1242_6ph,         /*     EEV1152x1242 6 PHASE          1152  1242    */
    KAI_1024x1024,             /*     KODAK 1024x1024 interline     1024  1024    */
    MIT_CCD_36,                /*     MIT CCD 36 special chip       2048  1024    */
    TEK_1024x1024_B_200ns,     /*     TEK1024x1024B Back Illm       1024  1024    */
    TEK_1024x1024_F_200ns,     /*  35 TEK1024x1024F Front Illm      1024  1024    */
    KDK_1024x1536,             /*     KODAK 1024x1536               1024  1536    */
    TEK_512x512_B_200ns,       /*     TEK512x512B [200ns]            512   512    */
    TEK_512x512_F_200ns,       /*     TEK512x512F [200ns]            512   512    */
    FCD_4096x4096F,            /*     Fairchild 4096 x 4096         4091  4096    */
    TEK_512x512D_B,            /*  40 TEK512x512D Back Illm          512   512    */
    TEK_512x512D_F,            /*     TEK512x512D Front Illm         512   512    */
    HAM_64x1024,               /*     HAMMAMATSU   64 x 1024          64  1024    */
    HAM_128x1024,              /*     HAMMAMATSU  128 x 1024         128  1024    */
    HAM_256x1024,              /*     HAMMAMATSU  256 x 1024         256  1024    */
    EEV_256x1024_8ph,          /*  45 EEV 256 x 1024 8 PHASE         256  1024    */
    EEV_1152x770_3ph,          /*     EEV1152x770  3 PHASE          1152   770    */
    EEV_1152x770_6ph,          /*     EEV 1152x770 6 PHASE          1152   770    */
    TEK_1024x1024_B_42usV,     /*     TEK1024x1024B Back Illm       1024  1024    */
    PID_330x1100_6phH,         /*     PI 330x1100 6 PHASE (horz)     330  1100    */
    EEV_256x1024_6ph_CCD30,    /*  50 EEV 256x1024  Front   CCD30    256  1024    */
    TEK_1024x1024D_B,          /*     TEK1024x1024D Back Illm       1024  1024    */
    TEK_1024x1024D_F,          /*     TEK1024x1024D Front Illm      1024  1024    */
    TEK_1024x1024D_B_T3,       /*     TEK1024x1024D Back Illm       1024  1024    */
    THM_512x512,               /*     Thomson 512X512 Front Illum    512   512    */
    THM_256x1024,              /*  55 Thomson 256X1024 FI MPP        256  1024    */
    THM_2048x1024_FT,          /*     Thomson 2048X1024 FT          1024  1024    */
    SIT_800x2000_B,            /*     SIT 800x2000 Back Illm         800  2000    */
    SIT_800x2000_F,            /*     SIT 800x2000 Front Illm        800  2000    */
    PID_240x330_MCT,           /*     TEST CHIP # 1                               */
    OEEV_1203x1336_3ph,        /*  60 EEV 1203x1336                 1203  1336    */
    OEEV_1203x1336_6ph,        /*     EEV 1203x1336                 1203  1336    */
    PI_800x1000_B,             /*     PI 800x1000 back               800  1000    */
    PI_64x1024,                /*     PI special   64 x 1024          64  1024    */
    PI_128x1024,               /*     PI special  128 x 1024         128  1024    */
    PI_256x1024,               /*  65 PI special  256 x 1024         256  1024    */
    KDK_4096x4096,             /*     Kodak 4096x4096               4096  4096    */
    EEV_100x1340_F,            /*     EEV 100x1340  Front   CCD36    100  1340    */
    PID_1030x1300,             /*     PI Special 1030x1300          1030  1300    */
    VICCD_NTSC_480x640,        /*     Video Chip - N. American Std   480   640    */
    VICCD_CCIR_576x768,        /*  70 Video Chip - European Std      576   768    */
    PID_582x782,               /*     PI Special 582x782             582   782    */
    PID_2500x600_B,            /*     PI 2500x600 Back              2500   600    */
    PID_2500x600_F,            /*     PI 2500x600 Front             2500   600    */
    PID_1024x512_SFT,          /*     PI 512x512                     512   512    */    
    EEV_400x1340,              /*  75 EEV 400x1340 Front             400  1340    */
    EEV_700x1340,              /*     EEV 700x1340 Front             700  1340    */
    EEV_1024x1024,             /*     EEV                               */
    EEV_1024x1024_FT,          /*     EEV frame transfer            1024  1024    */
    EEV_1300x1340,             /*     EEV 1300x1340 Front           1300  1340    */
    SIT_2048x2048_B,           /*  80 SITE 2048x2048 Back           2048  2048    */
    SIT_2048x2048_F,           /*     SITE 2028x2048 Front          2048  2048    */
    EEV_80x80,                 /*     EEV 80x80 FT                                */
    TEST_CCD36_00,             /*     Special ccd36 for EEV.         110  1356    */
    TEST_CCD36_10,             /*     Special ccd36 for EEV.         410  1356    */
    TEST_CCD36_20,             /*  85 Special ccd36 for EEV.         710  1356    */
    TEST_CCD36_40,             /*     Special ccd36 for EEV.        1330  1356    */
    THM_2048x2048,             /*     Thomson 2048x2048             2048  2048    */
    OEEV_1300x1340,            /*     EEV 1300x1340 [OverScan]      1300  1340    */
    EPIX_1300x1024,            /*     Epix Controller */    
    PIB_512x512_FT,            /*  90 PI Back 512x512 Frame Xfer(16-Tap)          */
    HAM_60x1024,               /*     HAMMAMATSU   60 x 1024          60  1024    */
    HAM_124x1024,              /*     HAMMAMATSU  124 x 1024         124  1024    */
    HAM_252x1024,              /*     HAMMAMATSU  252 x 1024         252  1024    */
    EEV_1024x512_FT_CCD57,     /*     EEV frame transfer CCD57      1024   512    */
    INGAAS_1x256,              /*  95 InGaAs chip                      1   256    */
    INGAAS_1x512,              /*     InGaAs chip Interleaving         1   512    */
    RSS_1024x1024,             /*     Roper Scientic Special FT     1024  1024    */  
    EEV_100x1340_B,            /*     EEV 100x1340  Back   CCD36     100  1340    */
    EEV_400x1340_B,            /*     EEV 400x1340  Back             400  1340    */
    EEV_700x1340_B,            /* 100 EEV 700x1340  Back             700  1340    */
    EEV_1300x1340_B,           /*     EEV 1300x1340 Back            1300  1340    */
    EEV_1024x1024_CCD47_10,    /*     EEV 1024x1024 CCD47-10        1024  1024    */
    EEV_512x2048_CCD42_10,     /*     EEV  512x2048 CCD42-10         512  2048    */
    EEV_2048x1024_FT_CCD47_20, /*     EEV2048x1024FT CCD47_20       2048  1024    */
    EEV_400x1340_B_FT,         /* 105 EEV 400x1340  Back Frame Xfer  400  1340    */
    EEV_256x1024_6ph_CCD30_B,  /*     EEV 256x1024  Back CCD30       256  1024    */
    EEV_256x1024_6ph_CCD30_OE, /*     EEV 256x1024  OE   CCD30       256  1024    */
    HAM_58x1024_B,             /*     HAMMAMATSU   58 x 1024 Back     58  1024    */
    HAM_122x1024_B,            /*     HAMMAMATSU  122 x 1024 Back    122  1024    */
    HAM_250x1024_B,            /* 110 HAMMAMATSU  250 x 1024 Back    250  1024    */
    EEV_2048x2048_CCD42_40,    /*     EEV 2048x2048 CCD42_40        2048  2048    */
    PID_330x1100_8phH_V2,      /*     PID  330x1100 [8ph] V2         330  1100    */
    RSS_1024x512_FT,           /*     Roper Scientic Special FT      512   512    */  
    KAF_2084x2084,             /*     Kodak 2084x2084 [KAF-4300E]   2084  2084    */
    EEV_100x1340_F_GATAN,      /* 115 EEV 100x1340  Front   CCD36    100  1340    */
    EEV_400x1340_F_GATAN,      /*     EEV 400x1340 Front             400  1340    */
    HAM_2x2048,                /*     HAM 2x2048 (CCD-PDA)             2  2048    */
    KAF_2084x2084_SCX,         /*     Kodak 2084x2084 [XRAY]        2084  2084    */
    MAR_576x576_FT_CCD65,      /*     Marconi 288x576 FT CCD65       576   576    */
    MAR_512x512_CCD77,         /* 120 Marconi 512x512 CCD77          512   512    */
    EEV_512x2048B_CCD42_10,    /*     EEV  512x2048 Back CCD42-10    512  2048    */
    INGAAS_1x1024,             /*     InGaAs chip                      1  1024    */
    XEN_256x320,               /*     Xenics InGaAs chip             320   256    */
    MIT_CCD_36SW,              /*     MIT CCD 36 (Summing Well)     2048  1024    */
    SUI_1x256LSB,              /* 125 Sensors Unlimited SU256LSB     256     1    */
    INGAAS_1x512L,             /*     InGaAs chip (Snsors Unlimited) 512     1    */
    EEV_100x1340_FX,           /*     EEV 100x1340  Front   CCD36    100  1340    */
    EEV_100x1340_BX,           /*     EEV 100x1340  Back    CCD36    100  1340    */
    EEV_400x1340_FX,           /*     EEV 400x1340  Front   CCD36    100  1340    */
    EEV_400x1340_BX,           /* 130 EEV 400x1340  Back    CCD36    100  1340    */
    SPHIT_1340x150,            /*     SpectraHIT                    1340   150    */ 
    END_OF_CCD_LIST            /* END OF ENUMERATED CCD TYPE,                     */
};

/* Controller interface type */
/* #### used by PICM_SetInterface param 1  #### */
enum interfaceType
{
    NotConnected=0,
    DMA_Interface,       /* DMA  : fast! (ISA board)                      */
    TAXI_Interface,      /* TAXI : fast serial  (ISA board)               */
    EISA_Interface,      /* EISA : EISA computer board                    */
    TAXI_TypeB_Interface,/* TAXI : ISA board in EISA computer, Type B DMA */
    GPIB_Interface,      /* GPIB : OK but not fast...                     */
    SUN_EDT_Interface,   /* Sun computer, EDT interface card.             */
    SERIAL_Interface,    /* Serial RS170 interface (VICCD)                */
    TAXI_TypeF_Interface,/* TAXI : ISA board in PCI computer, Type F DMA  */
    SCSI_Interface,      /* SCSI : interface using apsi.                  */
    OMA4ISA_Interface,   /* OMA4 : Interface using memory-mapped ISA card */
    PCI_COMPLEX_PC_Interface, /* PCI scatter-gather, for IBM-PC card.     */
    PCI_SIMPLE_PC_Interface,  /* PCI simple sw does all the work, for IBM */
                              /* PC card.                                 */
    PCI_COMPLEX_MAC_Interface,/* PCI scatter-gather, for MAC card.        */
    PCI_SIMPLE_MAC_Interface, /* PCI simple sw does all the work, for Mac */
    DEMO_Interface,           /* for demo software and test software.     */
    EISA_Enhanced_Interface,  /* Eisa with new Datacollection object and  */
                              /* ring zero driver                         */
    ECP_Interface,            /* Extended Communication Parallel interface*/
    DT3152_Interface,     /* Data Translation PCI Frame Grabber(RS170)*/
    PCI_FibreChannel_Interface,/* PCI Fast Fibre Channel Interface      */
    PCI_TIMER_Interface,    /* PCI With timer no interrupts */
    EPIX_Interface,         /* Epix Interface */
    USB_Interface,       /* Universal Serial Bus Interface */
	PI1394_Interface,		  /* PI 1394 ( firewire ) Interface			  */
};

/* shutter type definition */
enum installed_shutter
{                         /* In dialog, they are appeared as: */
    NO_SHUTTER = 1,       /*   None                           */
    LARGE_SHUTTER,        /*   Large                          */
    REMOTE_SHUTTER,       /*   Remote                         */
    SMALL_SHUTTER,        /*   Small                          */
    ELECTRONIC_SHUTTER,   /*   Electronic                     */
    CUSTOM_SHUTTER        /*   CUSTOM Comp                    */       
};

/* CCD chip frame readout mode  */
/* #### used by PICM_CREATECONTROLLER param 3  #### */
/* for normal data collection USE ReadFullFrame */
enum sensorReadoutMode
{
    READOUT_NOTUSED = 0,       /* Readout Mode not used               */
    ROM_FULL,                  /* normal data collection mode.        */
    ROM_FRAME_TRANSFER,        /* frame transfer mode (st138)         */
    ROM_KINETICS,              /* kinetics (st138)                    */
    ROM_INTERLINE,             /* interlined CCD mode                 */
    ODD_FRAME,                 /* viccd only                          */
    EVEN_FRAME,                /* viccd only                          */
    ANY_FRAME,                 /* viccd only                          */
    ROM_DIF                    /* ST133 5Mhz double image format.     */ 
};

/* @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ */
/*                 PICM_Set_acqmode                    */
/* @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ */
/* acquisition mode (timing mode) : FREERUN, ...       */
/* int PICM_Set_acqmode(int acqmode);                  */
/* Get acquisition mode set (timing mode)              */
/* int PICM_Get_acqmode(void);                         */


/* acquisition mode definitions, for timing mode   */
enum ctrl_acqmode
{
    CTRL_FREERUN = 1,
    CTRL_LINESYNC,
    CTRL_EXTSYNC,        /* same as extsync normal. */
    CTRL_EXTSYNC_NORMAL,
    CTRL_EXTSYNC_PREOPEN,
    CTRL_EXTTRIG,        /* same as exttrig normal. */
    CTRL_EXTTRIG_NORMAL,
    CTRL_EXTTRIG_PREOPEN,
    CTRL_FR_STORE_TRIG,      /* Free run with Store Trigger Enable        */
    CTRL_SN_STORE_TRIG,      /* ExtSync Normal with Store Trigger Enable  */
    CTRL_SP_STORE_TRIG,      /* ExtSync Preopen with Store Trigger Enable.*/
    CTRL_TN_STORE_TRIG,      /* ExtTrig Normal with Store Trigger Enable. */
    CTRL_TP_STORE_TRIG,      /* ExtTrig Preopen with Store Trigger Enable */
    CTRL_EXTSHUTTER_CONTROL, /* DC131 only external shutter control.      */
    CTRL_EVENT_COUNTER,      /* Event counter, only for ST121             */
    CTRL_LINE_SYNC_EXT_TRIG, /* Line sync and ext trigger.                */
    CTRL_LINE_SYNC_STR_ENA,  /* Line sync and stroe enable.               */
    CTRL_EXT_SYNC_EXT_TRIG,  /* Ext sync and ext trig.                    */
    CTRL_SWTRIGGER,          /* Pentamax Single Trigger Multiple Frames   */
    CTRL_KINETICS_NO_TRIGGER,/* Kinetics only, freerun.                   */
    CTRL_KINETICS_SINGLE,    /* Kinetics only, single trigger.            */
    CTRL_KINETICS_MULTIPLE,  /* Kinetics only, multiple trigger.          */
    CTRL_IEC,                /* Internal exposure control.                */
    CTRL_EEC,                /* External exposure control.                */
    CTRL_ESABI,              /* Electronic shutter action between images. */
    CTRL_INTERNAL_SYNC,      /* Sync come from backplane - only PTG       */
    CTRL_TRIGGER_FIRST,      /* Single trigger, continous data.           */
    CTRL_BULB,               /* Bulb trigger (pvcam)                      */
    CTRL_DIF_STM,            /* DIF Single Triggered Mode (ST133 5MHz)    */
    CTRL_DIF_DTM             /* DIF Dual Triggered Mode (ST133 5MHz)      */
};

/* sensor type definition */
/* #### used by PICM_CREATECONTROLLER param 2 (if diode array) #### */
enum ctrl_PDA_sensor
{
    NO_PDA_SENSOR =1000,
    DA0128S,                /* single  128 */
    DA0256S,                /* single  256 */
    DA0512S,                /* single  512 */
    DA1024S,                /* single 1024 */
    DA2048S,                /* single 2048 */
    DA0128D,                /* dual    128 */
    DA0256D,                /* dual    256 */
    DA0512D,                /* dual    512 */
    DA1024D,                /* dual   1024 */
    DA2048D,                /* dual   2048 ! */
    DA256S_INGAS,           /* Single 256 INGAS */
    DA512S_INGAS,           /* Single 512 INGAS */
    DA128S_GE,              /* Single 128 GE    */
    DA256S_GE,              /* Single 256 GE    */
    PDA_DUMMY               /* indicates end of list  */
};

/* @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ */
/*          PICM_Set_controller_ad_converter           */
/* @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ */
/* Controller AD converter                             */
/* int PICM_Set_controller_ad_converter(int converter);*/
/* int PICM_Get_controller_ad_converter(void);         */

/* Analog to Digital Converter type */
enum ADConverter_Type
{
    UNKNOWNADConverter = 0,
    Slow16BitsADConverter = 1,
    Fast12BitsADConverter,
    Fast16BitsADConverter,
    Slow14BitsADConverter,
    Slow15BitsADConverter,
    Slow12BitsADConverter,  /* PentaMax (slow relative)                     */
    Slow18BitsADConverter,  /* ST130 and OMA4 only                          */
    FAST_ADC,               /* Use this to select fast adc, use resolution  */
                            /* to select bits.                              */
    SLOW_ADC                /* Use this to select slow adc, use resolution  */
                            /* to select bits.                              */
};


/* @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ */
/*             PICM_Set_controller_speed               */
/* @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ */
/* controller timebase in Hz freq                      */
/* int PICM_Set_controller_speed(int freq);            */
/* int PICM_Get_controller_speed(void);                */

/* Controller speed (ADC rate) */
enum ctrl_speed
{   ADCUNKNOWNSPEED=0,/* 115/116/120/121/1000   130/135/138  131 */
    ADC25KHz = 1,     /*                          x   x   x       */
    ADC30KHz,         /*   x       x                              */
    ADC33KHz,         /*       x       x   x                      */
    ADC50KHz,         /*       x       x   x      x   x   x       */
    ADC60KHz,         /*   x       x                              */
    ADC100KHz,        /*   x   x   x   x   x      x   x   x       */
    ADC150KHz,        /*                                  x   x   */
    ADC200KHz,        /*       x       x   x      x   x   x       */
    ADC430KHz,        /*                                  x       */
    ADC500KHz,        /*                                  x       */
    ADC1MHz,          /*                                  x   f   */
    ADC2MHz,          /*                                  x   x   */
    ADC5MHz,          /*                                  x   f   */
    ADC40KHz,
    ADC333KHz,
    ADC700KHz,
    ADC1400KHz,
    ADC3MHz,
    ADC10MHz,
    ADC20MHz
};

/* @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ */
/*          PICM_Set_controller_adc_resolution         */
/* @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ */
/* Set the ADC resolution of the ADC-converter (i.e. 12 bits).             */
/* int PICM_Set_controller_adc_resolution(int adc_res);                    */
/* Get the ADC resolution set.                                             */
/* int PICM_Get_controller_adc_resolution(void);                           */

/* ADC resolution */
enum ADC_resolution
{
    UNKNOWN=0,
    ADC12BITS,
    ADC14BITS,
    ADC15BITS,
    ADC16BITS,
    ADC18BITS 
};

/* Data clip enumarted type, good only for taxi st138 systems. For ADCbitAdjust*/
enum clip_selections
{
    BA_NO_CLIP = 0,
    BA_CLIP1_LSB,
    BA_CLIP2_LSB,
    BA_CLIP1_MSB,
    BA_CLIP2_MSB,
    BA_CLIP_MSB_LSB
};

enum amplifier_values   /* for AmpHiCapLowNoise field.    */
{
    AMP_NOTUSED=0,
    AMP_LOWNOISE,
    AMP_HIGHCAP
};

enum XCALIBUNIT         /* definition of the calibration units */
{
    XW_NONE = 0,        /* error case */
    XW_SYSTEM,          /* relativ system units like channels,strips,frames... */
    XW_DATA,            /* absolut units including offset and linear factor */
    XW_POLYNOM,         /* polynomial calibration of user units */
    XW_WAVELENGTH,      /* polynomial calibration ofwavelength */
                        /* special types recalculated out of wavelength: */
    XW_ABSWAVENUM,      /*      wavenumber units */
    XW_RELWAVENUM,      /*      relative wavenumber units */
    XW_EVOLTS,          /*      electron volts */

    XW_XDUNITEND
};

// Define a value for each application type which is stored in the file header
// and may be used elsewhere also.
enum APP_TYPE
{
    APP_UNKNOWN = 0,
    APP_WINVIEW,
    APP_WINSPEC,
    APP_WINLITE,
    APP_WINXTEST
};

/* output settings for the Pentamax V5 BNC. and PIXIS */
#define NOT_SCAN           0
#define SHUTTER            1
#define NOT_RDY            2
#define LOGIC0             3
#define CLEANING           4
#define NOT_FT_IMAGE_SHIFT 5        /* Low when shifting ft image to storage area. */
#define BNC_RESERVED       6        /* NOT AVAILABLE.                              */
#define LOGIC1             7
///end IMPROVE_FILE_INFORMATION_WITH_MEANINGFUL_VALS

///Sophy 12/19/2009 QA80-12258-P3 MORE_WORK_ON_CVT_SPE_HEADER_TO_MEANINGFUL_VALS
//geometric
enum {
	DET_GEO_NORMAL = 0,
	DET_GEO_ROTATE = 0x0001,
	DET_GEO_REVERSE = 0x0002,
	DET_GEO_FLIP = 0x0004,
};
///end MORE_WORK_ON_CVT_SPE_HEADER_TO_MEANINGFUL_VALS




#define SPE_ERR_NONE						0
#define SPE_ERR_FILE_OPEN					1
#define SPE_ERR_READ_HEADER					2
#define SPE_ERR_READ_DATA					3
#define SPE_ERR_DATA_TYPE					4
#define SPE_ERR_CREATE_TEMP_MATRIX			5
#define SPE_ERR_CREATE_TEMP_MATRIX_PAGE		6
#define SPE_ERR_CREATE_WKS_PAGE				7
#define SPE_ERR_CREATE_WKS					8
#define SPE_ERR_CREATE_MATRIX_PAGE			9
#define SPE_ERR_CREATE_MATRIX				10
#define SPE_ERR_CREATE_NOTE_PAGE			11
#define SPE_ERR_YDIM						12
#define SPE_ERR_FRAME_NUMBER				13
#define SPE_ERR_FILTER_TYPE					14
#define SPE_ERR_TREE2STR					15
#define SPE_ERR_SEEK_DATA					16
